package org.simantics.jfreechart.chart.properties;

import java.util.Collection;
import java.util.Collections;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class AllVariablesOfModel implements Read<Collection<ChartVariable>> {
	
	public Resource model;
	
	/**
	 * Queries all variables of a model 
	 * @param res the model.
	 */
	public AllVariablesOfModel(Resource res) {
		this.model = res;
	}
	
	public Resource getModel() {
		return model;
	}
	
	@Override
	public Collection<ChartVariable> perform(ReadGraph graph) throws DatabaseException {
		if(!graph.hasStatement(model))
	         return Collections.emptyList();
		IAllVariablesOfModel query = graph.adapt(model, IAllVariablesOfModel.class);
		return graph.syncRequest(query.getVariablesQuery());
	}
	
	public static AllVariablesOfModel withRandomResource(ISessionContext context, final Resource resource) throws DatabaseException {
		Resource model  = context.getSession().syncRequest(new Read<Resource>() {

	        @Override
	        public Resource perform(ReadGraph graph) throws DatabaseException {
	            Resource r = resource;
	            while((r = graph.getPossibleObject(r, Layer0.getInstance(graph).PartOf)) != null) {
	                if(graph.isInstanceOf(r, SimulationResource.getInstance(graph).Model))
	                    return r;
	            }
	            return null;
	        }
	        
	    });
		if (model == null)
			return null;
		return new AllVariablesOfModel(model);
	}

}
