/*******************************************************************************
 * Copyright (c) 2007, 2014 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.properties;

import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.selectionview.StandardProperties;

/**
 * Tab adjusting the layout depending on its dimensions.
 * @author Tuomas Miettinen
 *
 */
public abstract class AdjustableTab extends LabelPropertyTabContributor {

	private Composite spp;
	private ControlListener controlListener;
	private static final int WIDE_SCREEN_WIDTH = 1100;
	protected Composite composite;
	
	public AdjustableTab(Object id) {
	    super(id);
	}
	
	@Override
	public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport _support) {
		// Get size of the available area.
		spp = body;
		do {
			spp = spp.getParent();
		} while (!(spp instanceof StandardProperties));
		
		// Add listener to change the layout when the composite resizes.
		spp.addControlListener(controlListener = new ControlListener(){

			@Override
			public void controlMoved(ControlEvent e) {}

			@Override
			public void controlResized(ControlEvent e) {
				createLayout();
			}
		});
		
		// Create the controls and their initial layout.
		createAndAddControls(body, site, context, _support);
		createLayout();	
	}

	/**
	 * Create controls and add them to the tab.
	 * @param body the composite where the controls are added.
	 * @param site
	 * @param context
	 * @param _support
	 */
	protected abstract void createAndAddControls(Composite body, IWorkbenchSite site,
			ISessionContext context, WidgetSupport _support);

	/**
	 *  Create layout for controls.
	 */
	protected void createLayout() {
		if (composite == null || composite.isDisposed())
			return;
		
		Point size = spp.getSize();
		if (size.x > size.y) {
			createControlLayoutHorizontal((size.x > WIDE_SCREEN_WIDTH));
		} else {
			createControlLayoutVertical();
		}
	}
	
	/**
	 * Determine if the layout uses vertical layout
	 * @return true iff the layout uses vertical layout
	 */
	protected boolean isVertical() {
		Point size = spp.getSize();
		return size.x < size.y;
	}
	
	/**
	 * Create vertical layout for controls.
	 */
	protected abstract void createControlLayoutVertical();

	/**
	 * Create horizontal layout for controls.
	 * @param wideScreen true iff the control is wider than WIDE_SCREEN_WIDTH
	 */
	protected abstract void createControlLayoutHorizontal(boolean wideScreen);

//	@Override
//	public void dispose() {
//		if(controlListener != null && spp != null)
//			spp.removeControlListener(controlListener);
//	}

}
