/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.element;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.geom.AffineTransform;
import java.io.IOException;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.g2d.dnd.DnDHints;
import org.simantics.g2d.dnd.ElementClassDragItem;
import org.simantics.g2d.dnd.IDnDContext;
import org.simantics.g2d.dnd.IDropTargetParticipant;
import org.simantics.g2d.element.ElementHints;
import org.simantics.modeling.ui.diagramEditor.PopulateElementDropParticipant;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.utils.ui.AdaptionUtils;

/**
 * Drop participant for dropping chart definitions into diagrams
 * @author Teemu Lempinen
 *
 */
public class PopulateChartDropParticipant extends PopulateElementDropParticipant implements IDropTargetParticipant {

    public PopulateChartDropParticipant(GraphToDiagramSynchronizer synchronizer) {
        super(synchronizer);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde, final IDnDContext dp) {
        Transferable tr = dtde.getTransferable();
        if (tr.isDataFlavorSupported(LocalObjectTransferable.FLAVOR)) {

            Session session = synchronizer.getSession();

            Object obj = null;

            try {
                obj = tr.getTransferData(LocalObjectTransferable.FLAVOR);
                
                // Create a structural selection from transfer data
                if (!(obj instanceof IStructuredSelection)) {
                    obj = LocalObjectTransfer.getTransfer().getObject();
                }

                if (obj instanceof IStructuredSelection) {

                    IStructuredSelection sel = (IStructuredSelection) obj;
                    
                    // Can drop only one chart at the time
                    if (sel.size() == 1) {
                        
                        // Get the chart definition
                        Resource chart = AdaptionUtils.adaptToSingle(sel, Resource.class);
                        if (chart == null)
                            return;

                        ElementClassDragItem item = session.syncRequest(new UnaryRead<Resource,ElementClassDragItem>(chart) {

                            @Override
                            public ElementClassDragItem perform(ReadGraph graph) throws DatabaseException {
                                if(graph.isInstanceOf(parameter, JFreeChartResource.getInstance(graph).Chart)) {
                                    ElementClassDragItem item = new ElementClassDragItem(ChartElementFactory.create(graph, parameter));
                                    AffineTransform initialTr = AffineTransform.getScaleInstance(1, 1);
                                    item.getHintContext().setHint(ElementHints.KEY_TRANSFORM, initialTr);
                                    return item;
                                } else {
                                    return null;
                                }

                            }
                        });

                        if(item != null) {
                            dp.add(item);
                            dp.getHints().setHint(DnDHints.KEY_DND_GRID_COLUMNS, Integer.valueOf(1));
                        }

                    }

                }

            } catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            } catch (DatabaseException e) {
                e.printStackTrace();
            }

        }

        dtde.acceptDrag(DnDConstants.ACTION_COPY);
    }
}
