package org.simantics.jfreechart.chart;

/**
 * Interface for configuring data filtering.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public interface FilteredDataset {

	public boolean isFiltering();
	public void setFiltering(boolean filtering);
	
	
	public double getFilterFraction();
	/**
	 * Sets filtering fraction 0 <= fraction <= 1
	 * With filtering fraction 0 nothing gets filtered.
	 * With filtering fraction 1 everything gets filtered.
	 * 
	 * @param filterFraction
	 */
	public void setFilterFraction(double filterFraction);
	
	public void updateFiltered();
	
	@SuppressWarnings("rawtypes")
	public Comparable getOther();
}
