/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart;

import java.awt.Color;
import java.util.ArrayList;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.G2DUtils;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.datastructures.Pair;

public class ConstantXYDatasetRequest implements Read<Pair<ArrayList<ConstantXYDatasetSeries>, IRenderer>>{

    protected Resource dataset;
    
    public ConstantXYDatasetRequest(Resource dataset) {
        this.dataset = dataset;
    }
    
    @Override
    public Pair<ArrayList<ConstantXYDatasetSeries>, IRenderer> perform(ReadGraph graph) throws DatabaseException {

    	JFreeChartResource jfree = JFreeChartResource.getInstance(graph);

        // Renderer
        IRenderer renderer = null;
        Resource rendererResource = graph.getPossibleObject(dataset, jfree.Dataset_renderer);
        if(rendererResource != null)
            renderer = graph.adapt(rendererResource, IRenderer.class);

        ArrayList<ConstantXYDatasetSeries> series = new ArrayList<ConstantXYDatasetSeries>();

        Resource seriesList = graph.getPossibleObject(dataset, jfree.Dataset_seriesList);

        // Get properties for all series
        if(seriesList != null) {

        	for(Resource r : ListUtils.toList(graph, seriesList)) {
            	
            	double[] xData = graph.getPossibleRelatedValue(r, jfree.ConstantSeries_xData, Bindings.DOUBLE_ARRAY);
            	double[] yData = graph.getPossibleRelatedValue(r, jfree.ConstantSeries_yData, Bindings.DOUBLE_ARRAY);
            	
            	// Get visual properties
            	Integer width = graph.getPossibleRelatedValue(r, jfree.Series_lineWidth, Bindings.INTEGER);
            	if(width == null) width = 1;

            	Resource c = graph.getPossibleObject(r, jfree.color);
            	Color color = c == null ? null : G2DUtils.getColor(graph, c);

            	String label = graph.getPossibleRelatedValue(r, Layer0.getInstance(graph).HasName);

            	if(xData!=null && yData!=null && (xData.length == yData.length)) {
            		// Add series if everything OK
            		String name = label;
            		if(xData.length != 0 && yData.length != 0) {
            			ConstantXYDatasetSeries tempSeries = new ConstantXYDatasetSeries(name, new double[][] { xData, yData }, width, color);
            			series.add(tempSeries);
            		}
            	}
            	
            }
        }
        
        return new Pair<ArrayList<ConstantXYDatasetSeries>, IRenderer>(series, renderer);
        
    }

    
}
