/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;


/**
 * Abstract dataset class for all JFreeChart datasets
 * 
 * @author Teemu Lempinen
 *
 */
public abstract class AbstractDataset implements IDataset {

    protected Resource resource;
    
    public AbstractDataset(Resource resource) throws DatabaseException {
        this.resource = resource;
    }
    
    @Override
    public void dispose() {
        
    }

    @Override
    public Resource getResource() {
        return resource;
    }

}
