/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/**
 * Class for separating charts in {@link ChartPanel}. Acts as a drop participant for adding
 * and moving charts in {@link ChartPanel}.
 * 
 * @author Teemu Lempinen
 *
 */
public class ChartPanelSeparator extends Composite {

    private ChartPanel panel;

    @Override
    public Object getLayoutData() {
        checkWidget();
        Object oldData = super.getLayoutData();
        if(oldData == null || !(oldData instanceof GridData)) {
            oldData = GridDataFactory.fillDefaults().create();
        }
        GridData data = (GridData) oldData;
        // Empty panel -> drop area the size of the whole panel
        if(panel.getElements().size() == 1 && panel.getElements().get(0).getResource() == null) {
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
        }
        else {
            if(panel.isVertical()) { 
                data.grabExcessHorizontalSpace = true;
                data.grabExcessVerticalSpace = false;
            } else {
                data.grabExcessHorizontalSpace = false;
                data.grabExcessVerticalSpace = true;
            }
        }
        return data;
    }

    /**
     * Set up a small horizontal or vertical separator depending on SWT style
     * 
     * @param parent
     * @param style
     */
    public ChartPanelSeparator(Composite parent, ChartPanel panel, ChartPanelElement element, int style) {
        super(parent, style);
        GridLayoutFactory.fillDefaults().margins(2, 2).applyTo(this);
        GridDataFactory.fillDefaults().applyTo(this);
        this.panel = panel;
        addMouseListener(new SCFocusListener(panel));
    }


    /**
     * Listener for directing focus to scrollableComposite
     * @author Teemu Lempinen
     *
     */
    private class SCFocusListener extends MouseAdapter {
        ChartPanel panel;
        public SCFocusListener(ChartPanel panel) {
            this.panel = panel;
        }
        public void mouseDown(MouseEvent e) {
            panel.setFocus();
        }
    }

}
