/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.simantics.db.Resource;
import org.simantics.utils.ui.AdaptionUtils;

/**
 * Drop target for dropping charts in chart panel
 * @author Teemu Lempinen
 *
 */
public class ChartDropTarget extends DropTargetAdapter {
    
    private Composite separator;
    private ChartPanelElement element;
    private Display display;
    private ChartPanel panel;
    
    public ChartDropTarget(Composite separator, ChartPanelElement element, ChartPanel panel) {
        this.separator = separator;
        this.display = separator.getDisplay();
        this.element = element;
        this.panel = panel;
    }
    


    /**
     * Display effect on the composite when drag entered
     */
    @Override
    public void dragEnter(DropTargetEvent event) {
        if ((event.operations & DND.DROP_COPY) != 0) {
            event.detail = DND.DROP_COPY;
        } else if ((event.operations & DND.DROP_MOVE) != 0) {
            event.detail = DND.DROP_MOVE;
        } else {
            event.detail = DND.DROP_NONE;
        }
        separator.setBackground(display.getSystemColor(SWT.COLOR_DARK_GRAY));
    }

    /**
     * Revert effect when drag leaves
     */
    @Override
    public void dragLeave(DropTargetEvent event) { 
        separator.setBackground(display.getSystemColor(SWT.COLOR_WIDGET_BACKGROUND));
    }

    /**
     * Drop the data to chart panel
     */
    @Override
    public void drop(DropTargetEvent event) {
        Resource chartResource = AdaptionUtils.adaptToSingle(event.data, Resource.class);
        if(chartResource != null)
            panel.addChart(chartResource, element);
    }

}
