/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.issues.common.IssuesOfSeverity;
import org.simantics.issues.ui.ontology.IssueUIResource;
import org.simantics.layer0.Layer0;

public class SeverityFolderLabelRule
implements LabelRule {
    private final String DESCRIPTION = "single";
    final Resource rule;

    public SeverityFolderLabelRule(Resource rule) {
        this.rule = rule;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueUIResource UI = IssueUIResource.getInstance((ReadGraph)graph);
        Resource project = (Resource)content;
        Resource severity = graph.getSingleObject(this.rule, UI.IssueBrowseContext_SeverityFolderLabelRule_HasSeverity);
        String severityName = (String)graph.getRelatedValue(severity, L0.HasName, (Binding)Bindings.STRING);
        Set issues = (Set)graph.syncRequest((Read)new IssuesOfSeverity(project, severity));
        if (issues.size() > 1) {
            return Collections.singletonMap("single", severityName + "s (" + issues.size() + " items)");
        }
        return Collections.singletonMap("single", severityName + "s (1 item)");
    }
}

