/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.ActionFactory2;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.issues.ui.ontology.IssueUIResource;
import org.simantics.utils.ui.ISelectionUtils;

public class SetSeverityAction
implements ActionFactory,
ActionFactory2 {
    final Resource action;

    public SetSeverityAction(Resource action) {
        this.action = action;
    }

    public Runnable create(Object target) {
        if (!(target instanceof Variable)) {
            return null;
        }
        return this.setSeverity(Collections.singletonList((Variable)target));
    }

    public Runnable create(Collection<?> targets) {
        Set variables = ISelectionUtils.filterSetSelection(targets, Variable.class);
        return this.setSeverity(variables);
    }

    private Runnable setSeverity(final Collection<Variable> issues) {
        return new Runnable(){

            @Override
            public void run() {
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        IssueUIResource UI = IssueUIResource.getInstance((ReadGraph)graph);
                        Resource severity = graph.getSingleObject((this).SetSeverityAction.this.action, UI.Actions_SetSeverityAction_HasSeverity);
                        SetSeverityAction.setSeverity(graph, severity, issues);
                    }
                });
            }
        };
    }

    public static void setSeverity(WriteGraph graph, final Resource severity, Collection<Variable> issues) throws DatabaseException {
        for (Variable issue : issues) {
            final Resource resource = issue.getRepresents((ReadGraph)graph);
            VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
            VirtualGraph vg = vgs.getGraph((ReadGraph)graph, resource);
            graph.sync((WriteInterface)new WriteRequest(vg){

                public void perform(WriteGraph graph) throws DatabaseException {
                    IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
                    graph.deny(resource, ISSUE.Issue_HasSeverity);
                    graph.claim(resource, ISSUE.Issue_HasSeverity, null, severity);
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Changed severity of " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)resource) + " to " + NameUtils.getSafeName((ReadGraph)graph, (Resource)severity)));
                }
            });
        }
    }
}

