/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.handler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.utils.TagUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.function.DbConsumer;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.SWTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveRelatedIssuesContribution
extends ContributionItem
implements IExecutableExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveRelatedIssuesContribution.class);
    protected ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    protected ImageDescriptor tickIcon = BundleUtils.getImageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/tick.png");
    protected ImageDescriptor bulbIcon = BundleUtils.getImageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/lightbulb_off.png");
    protected boolean resolve = true;
    protected boolean unresolve = false;
    protected int modCount = 0;

    /*
     * WARNING - void declaration
     */
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        Object object;
        if ("class".equals(propertyName) && (object = data) instanceof String) {
            void params;
            String[] parameters;
            String string = (String)object;
            String cfr_ignored_0 = (String)object;
            String[] stringArray = parameters = params.split(";");
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                String[] keyValue = parameter.split("=");
                if (keyValue.length == 2) {
                    if ("resolve".equals(keyValue[0])) {
                        this.resolve = Boolean.parseBoolean(keyValue[1]);
                    }
                    if ("unresolve".equals(keyValue[0])) {
                        this.unresolve = Boolean.parseBoolean(keyValue[1]);
                    }
                }
                ++n2;
            }
        }
    }

    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        super.dispose();
    }

    public boolean isDynamic() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected IStructuredSelection getSelection() {
        IStructuredSelection iStructuredSelection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelectionService service = window.getSelectionService();
        ISelection sel = service.getSelection();
        ISelection iSelection = sel;
        if (iSelection instanceof IStructuredSelection) {
            void ss;
            IStructuredSelection iStructuredSelection2 = (IStructuredSelection)iSelection;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
            iStructuredSelection = ss;
        } else {
            iStructuredSelection = null;
        }
        return iStructuredSelection;
    }

    public void fill(final Menu menu, final int index) {
        if (!this.resolve && !this.unresolve) {
            return;
        }
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        final int myCount = ++this.modCount;
        final Display display = menu.getDisplay();
        Simantics.getSession().asyncRequest((Read)new FindRelatedIssues(selection, this.resolve), (Procedure)new Procedure<List<IssueState>>(){

            public void execute(List<IssueState> relatedIssues) {
                if (relatedIssues.isEmpty()) {
                    return;
                }
                SWTUtils.asyncExec((Display)display, () -> ResolveRelatedIssuesContribution.this.contributeMenuItems(menu, index, relatedIssues, myCount));
            }

            public void exception(Throwable t) {
                LOGGER.error("Discovery of resolvable related issues for menu failed.", t);
            }
        });
    }

    private void contributeMenuItems(Menu parentMenu, int index, List<IssueState> relatedIssues, int myCount) {
        List<Resource> issues;
        if (relatedIssues.isEmpty() || myCount != this.modCount || parentMenu.isDisposed() || this.resourceManager == null) {
            return;
        }
        if (this.unresolve && !(issues = relatedIssues.stream().filter(IssueState::resolved).map(IssueState::issue).toList()).isEmpty()) {
            this.addMenuItem(parentMenu, index, new ResolveIssues("Unresolve Related Issues", this.bulbIcon, false, issues));
        }
        if (this.resolve && !(issues = relatedIssues.stream().filter(IssueState::notResolved).map(IssueState::issue).toList()).isEmpty()) {
            this.addMenuItem(parentMenu, index, new ResolveIssues("Resolve Related Issues", this.tickIcon, true, issues));
        }
    }

    private static List<IssueState> findRelatedIssues(ReadGraph graph, IStructuredSelection s, boolean resolved) throws DatabaseException {
        List wses = WorkbenchSelectionUtils.getWorkbenchSelectionElements((ISelection)s);
        HashSet issues = new HashSet();
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        DbConsumer fi = r -> {
            for (Resource issue : graph.getObjects(r, issueResource.Issue_HasContext_Inverse)) {
                issues.add(new IssueState(issue, graph.hasStatement(issue, issueResource.Resolved)));
            }
        };
        for (WorkbenchSelectionElement wse : wses) {
            Resource r2 = WorkbenchSelectionUtils.getPossibleResource((RequestProcessor)graph, (Object)wse);
            if (r2 == null) continue;
            fi.accept((Object)r2);
            for (Resource component : graph.getObjects(r2, MOD.ElementToComponent)) {
                fi.accept((Object)component);
            }
            for (Resource element : graph.getObjects(r2, MOD.ComponentToElement)) {
                fi.accept((Object)element);
            }
        }
        return new ArrayList<IssueState>(issues);
    }

    private void addMenuItem(Menu parentMenu, int index, ResolveIssues action) {
        MenuItem item = new MenuItem(parentMenu, 8, index);
        item.setText(action.getText());
        item.setToolTipText(action.getToolTipText());
        ImageDescriptor img = action.getImageDescriptor();
        if (img != null) {
            item.setImage((Image)this.resourceManager.get((DeviceResourceDescriptor)img));
        }
        item.addSelectionListener((SelectionListener)action);
    }

    protected static class FindRelatedIssues
    extends BinaryRead<IStructuredSelection, Boolean, List<IssueState>> {
        public FindRelatedIssues(IStructuredSelection s, boolean resolved) {
            super((Object)s, (Object)resolved);
        }

        public List<IssueState> perform(ReadGraph graph) throws DatabaseException {
            LOGGER.trace(FindRelatedIssues.class.getName());
            return ResolveRelatedIssuesContribution.findRelatedIssues(graph, (IStructuredSelection)this.parameter, (Boolean)this.parameter2);
        }
    }

    private record IssueState(Resource issue, boolean resolved) {
        boolean notResolved() {
            return !this.resolved();
        }
    }

    protected static class ResolveIssues
    extends Action
    implements SelectionListener {
        private final boolean resolve;
        private final List<Resource> issues;

        public ResolveIssues(String text, ImageDescriptor image, boolean resolve, List<Resource> issues) {
            super(text, image);
            this.resolve = resolve;
            this.issues = issues;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(final SelectionEvent e) {
            new TagUtil(null, "http://www.simantics.org/Issue-1.2/Resolved", this.resolve){

                protected void handleError(DatabaseException ex) {
                    String msg = NLS.bind((String)"Failed to {0} for {1} issues", (Object)this.getText(), (Object)issues.size());
                    LOGGER.error(msg, (Object)e);
                    ExceptionUtils.logAndShowError((String)"Resolve Failed", (String)msg, (Throwable)ex);
                }
            }.execute(Simantics.getSession(), this.issues);
        }
    }
}

