/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.issues.common.IssueUtils;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.issues.ui.handler.Messages;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.dialogs.ListDialog;

public class ConfigureIssueSources
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            Resource indexRoot = (Resource)Simantics.getSession().syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource()));
            ConfigureIssueSources.executeDefault(indexRoot);
        }
        catch (DatabaseException e) {
            throw new ExecutionException("Exception while showing validation configuration dialog", (Throwable)e);
        }
        return null;
    }

    public static void executeDefault(final Resource indexRoot) throws ExecutionException {
        if (indexRoot == null) {
            return;
        }
        try {
            List sources = (List)Simantics.getSession().syncRequest((Read)new UniqueRead<List<IssueSourceEntry>>(){

                public List<IssueSourceEntry> perform(ReadGraph graph) throws DatabaseException {
                    if (indexRoot == null) {
                        return Collections.emptyList();
                    }
                    ArrayList<IssueSourceEntry> result = new ArrayList<IssueSourceEntry>();
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
                    for (Resource type : QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)indexRoot, (Resource)ISSUE.IssueSourceType)) {
                        String name = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)type);
                        boolean exists = graph.syncRequest((Read)new PossibleObjectWithType(indexRoot, L0.ConsistsOf, type)) != null;
                        boolean deprecated = graph.hasStatement(type, L0.Deprecated);
                        boolean abstract_ = graph.hasStatement(type, L0.Abstract);
                        if (!exists && (deprecated || abstract_)) continue;
                        result.add(new IssueSourceEntry(name, type, exists));
                    }
                    return result;
                }
            });
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ListDialog<IssueSourceEntry> dialog = new ListDialog<IssueSourceEntry>(shell, (Collection)sources, Messages.ConfigureIssueSources_SelectAvailableIssueSources, Messages.ConfigureIssueSources_SelectedSourcesAddRemoveMsg){

                protected CheckboxTableViewer createViewer(Composite composite) {
                    CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
                    viewer.setCheckStateProvider(new ICheckStateProvider(){

                        public boolean isGrayed(Object o) {
                            return false;
                        }

                        public boolean isChecked(Object o) {
                            IssueSourceEntry entry = (IssueSourceEntry)((Object)o);
                            return entry.isChecked();
                        }
                    });
                    viewer.addCheckStateListener(e -> {
                        IssueSourceEntry entry = (IssueSourceEntry)((Object)((Object)e.getElement()));
                        entry.setChecked(e.getChecked());
                    });
                    viewer.getTable().addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> viewer.getTable().deselectAll()));
                    return viewer;
                }
            };
            int result = dialog.open();
            if (result != 0) {
                return;
            }
            Simantics.getSession().syncRequest(graph -> {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                for (IssueSourceEntry entry : sources) {
                    Resource existing = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(indexRoot, L0.ConsistsOf, entry.getResource()));
                    if (existing == null && entry.isChecked()) {
                        String name = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)entry.getResource());
                        IssueUtils.addIssueSource((WriteGraph)graph, (Resource)indexRoot, (Resource)entry.getResource(), (String)name);
                    }
                    if (existing == null || entry.isChecked()) continue;
                    RemoverUtil.remove((WriteGraph)graph, (Resource)existing);
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    private static class IssueSourceEntry
    extends NamedResource {
        private boolean checked;

        public IssueSourceEntry(String name, Resource resource, boolean checked) {
            super(name, resource);
            this.checked = checked;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean value) {
            this.checked = value;
        }
    }
}

