/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.ui.handler;

import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.variable.Variable;

/**
 * @author Tuukka Lehtonen
 * @since 1.27.0
 */
public class Help implements ActionFactory {

	@Override
	public Runnable create(Object target) {
		if (target instanceof Variable) {
			return () -> {
				try {
					String id = Simantics.sync(new PossibleVariablePropertyValue<String>((Variable) target, "contextualHelpId", Bindings.STRING)); //$NON-NLS-1$
					if (id == null) {
						PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
						return;
					}
					PlatformUI.getWorkbench().getHelpSystem().displayHelp(id);
				} catch (DatabaseException e) {
					Logger.defaultLogError(e);
				}
			};
		}

		return null;
	}

	static class PossibleVariablePropertyValue<T> extends TernaryRead<Variable, String, Binding, T> {

		public PossibleVariablePropertyValue(Variable variable, String property, Binding binding) {
			super(variable, property, binding);
		}

		@Override
		public T perform(ReadGraph graph) throws DatabaseException {
			return parameter.getPossiblePropertyValue(graph, parameter2, parameter3);
		}

	}

}
