package org.simantics.issues.ui.contribution;

import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.modeling.PropertyVariables;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class IssueContextDropAction implements DropActionFactory {

    @Override
    public Runnable create(ReadGraph g, Object target, Object source, int operation) throws DatabaseException {
        //System.out.println("DROP: " + source + " -> " + target);

        final Resource issue= ISelectionUtils.getSinglePossibleKey(target, SelectionHints.KEY_MAIN, Resource.class);
        if (issue == null)
            return null;

        final List<PropertyVariables> vars = ISelectionUtils.getPossibleKeys(source, SelectionHints.KEY_MAIN, PropertyVariables.class);
        if (!vars.isEmpty()) {
            //System.out.println("TODO: add property container to context");
        } else {
            List<Resource> ctx = ISelectionUtils.getPossibleKeys(source, SelectionHints.KEY_MAIN, Resource.class);
            if (!ctx.isEmpty())
                addToIssueContext(g.getSession(), issue, ctx);
        }

        return null;
    }

    private void addToIssueContext(Session session, final Resource issue, final List<Resource> contexts) {
        session.asyncRequest(new WriteRequest() {
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
                final IssueResource ISSUE = IssueResource.getInstance(graph);
                for (Resource ctx : contexts) {
                    graph.claim(issue, ISSUE.Issue_HasContext, ISSUE.Issue_HasContext, ctx);
                }
            }
        }, e -> {
            if (e != null)
                ErrorLogger.defaultLogError(e);
        });
    }

}
