package org.simantics.issues.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.issues.common.IssuesOfSeverity;
import org.simantics.issues.ui.ontology.IssueUIResource;

public class SeverityFolderRule implements ChildRule {

	final Resource rule;
	
	public SeverityFolderRule(Resource rule) {
		this.rule = rule;
	}
	
    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {

    	IssueUIResource UI = IssueUIResource.getInstance(graph);
    	Resource project = (Resource)parent;
    	Resource severity = graph.getSingleObject(rule, UI.IssueBrowseContext_SeverityFolderRule_HasSeverity);
        Set<Variable> issues = graph.syncRequest(new IssuesOfSeverity(project, severity));
        if(!issues.isEmpty()) return Collections.singleton(project);
        else return Collections.emptyList();
        
    }

    @Override
    public Collection<?> getParents(ReadGraph graph, Object child)
            throws DatabaseException {
    	return Collections.singleton(child);
    }


}
