/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.ui.handler;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.common.preferences.IssuePrefs;

/**
 * @author Tuukka Lehtonen
 */
public class ToggleShowNormalIssues extends PreferenceHandler {

    @Override
    protected boolean process(WriteGraph graph) throws DatabaseException {
        Resource project = Simantics.getProjectResource();
        if (project != null) {
            boolean show = IssuePrefs.showNormalIssues(graph, project);
            IssuePrefs.setShowNormalIssues(graph, project, !show);
        }
        return false;
    }

    @Override
    protected boolean isChecked(ReadGraph graph) throws DatabaseException {
        return IssuePrefs.showNormalIssues(graph, Simantics.getProjectResource());
    }

}
