/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.ui;

import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.issues.ontology.IssueResource;

/**
 * @author Tuukka Lehtonen
 */
public class UserIssueTest implements Test {

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return Resource.class.equals(contentType) || Variable.class.equals(contentType);
    }

    @Override
    public boolean test(ReadGraph graph, Object content) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance(graph);
        if (content instanceof Resource)
            return graph.hasStatement((Resource) content, ISSUE.UserIssue);
        if (content instanceof Variable) {
            Variable v = (Variable) content;
            Resource r = v.getPossibleRepresents(graph);
            if (r != null)
                return graph.hasStatement(r, ISSUE.UserIssue);
        }
        return false;
    }

}
