package org.simantics.issues.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.ActionFactory2;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.issues.ui.ontology.IssueUIResource;
import org.simantics.utils.ui.ISelectionUtils;

public class SetSeverityAction implements ActionFactory, ActionFactory2 {
	
	final Resource action;
	
	public SetSeverityAction(Resource action) {
		this.action = action;
	}

	@Override
	public Runnable create(Object target) {
		if(!(target instanceof Variable))
			return null;
		return setSeverity(Collections.singletonList(((Variable) target)));
	}

	@Override
	public Runnable create(Collection<?> targets) {
		Set<Variable> variables = ISelectionUtils.filterSetSelection(targets, Variable.class);
		return setSeverity(variables);
	}

	private Runnable setSeverity(final Collection<Variable> issues) {
		return new Runnable() {
			@Override
			public void run() {
				Simantics.getSession().asyncRequest(new WriteRequest() {
					@Override
					public void perform(WriteGraph graph) throws DatabaseException {
						graph.markUndoPoint();
						IssueUIResource UI = IssueUIResource.getInstance(graph); 
						Resource severity = graph.getSingleObject(action, UI.Actions_SetSeverityAction_HasSeverity);
						setSeverity(graph, severity, issues);
					}
				});
			}
		};
	}

	public static void setSeverity(WriteGraph graph, final Resource severity, Collection<Variable> issues) throws DatabaseException {
		for (Variable issue : issues) {
			final Resource resource = issue.getRepresents(graph);
			VirtualGraphSupport vgs = graph.getService(VirtualGraphSupport.class);
			VirtualGraph vg = vgs.getGraph(graph, resource);
			graph.sync(new WriteRequest(vg) {
				@Override
				public void perform(WriteGraph graph) throws DatabaseException {
					IssueResource ISSUE = IssueResource.getInstance(graph);
					graph.deny(resource, ISSUE.Issue_HasSeverity);
					graph.claim(resource, ISSUE.Issue_HasSeverity, null, severity);
					Layer0Utils.addCommentMetadata(graph, "Changed severity of " + NameUtils.getSafeLabel(graph, resource) + " to " + NameUtils.getSafeName(graph, severity));	 //$NON-NLS-1$ //$NON-NLS-2$
				}
			});
		}
	}

}
