/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common.preferences;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.ui.ontology.IssueUIResource;

public final class IssuePrefs {
    public static boolean showHiddenIssues(ReadGraph graph, Resource project) throws DatabaseException {
        return IssuePrefs.testBoolean(graph, project, IssueUIResource.getInstance((ReadGraph)graph).ShowHiddenIssues, false);
    }

    public static boolean showNormalIssues(ReadGraph graph, Resource project) throws DatabaseException {
        return IssuePrefs.testBoolean(graph, project, IssueUIResource.getInstance((ReadGraph)graph).ShowNormalIssues, true);
    }

    public static boolean showUserIssues(ReadGraph graph, Resource project) throws DatabaseException {
        return IssuePrefs.testBoolean(graph, project, IssueUIResource.getInstance((ReadGraph)graph).ShowUserIssues, true);
    }

    private static boolean testBoolean(ReadGraph graph, Resource project, Resource property, boolean defaultValue) throws DatabaseException {
        if (project == null) {
            return defaultValue;
        }
        Boolean b = (Boolean)graph.getPossibleRelatedValue(project, property, (Binding)Bindings.BOOLEAN);
        return b == null ? defaultValue : b;
    }

    public static void setShowHiddenIssues(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        IssuePrefs.setBoolean(graph, project, IssueUIResource.getInstance((ReadGraph)graph).ShowHiddenIssues, show);
    }

    public static void setShowNormalIssues(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        IssuePrefs.setBoolean(graph, project, IssueUIResource.getInstance((ReadGraph)graph).ShowNormalIssues, show);
    }

    public static void setShowUserIssues(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        IssuePrefs.setBoolean(graph, project, IssueUIResource.getInstance((ReadGraph)graph).ShowUserIssues, show);
    }

    private static void setBoolean(WriteGraph graph, Resource project, Resource property, boolean value) throws DatabaseException {
        graph.claimLiteral(project, property, (Object)value, (Binding)Bindings.BOOLEAN);
    }
}

