/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.issue.AnonymousIssue;
import org.simantics.db.common.issue.StandardIssue;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.ontology.IssueResource;

public class StandardIssueDescription
extends ResourceRead<Issue> {
    public StandardIssueDescription(Resource issue) {
        super(issue);
    }

    public Issue perform(ReadGraph graph) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        Resource type = graph.getPossibleType(this.resource, ISSUE.Issue);
        if (type == null) {
            return null;
        }
        Resource list = graph.getPossibleObject(this.resource, ISSUE.Issue_HasContexts);
        if (list == null) {
            if (graph.isInheritedFrom(type, ISSUE.Sources_DependencyTracker_AnonymousIssue)) {
                return new AnonymousIssue(type, Collections.singletonList(this.resource));
            }
            return new StandardIssue(type, Collections.singletonList(this.resource));
        }
        List contexts = ListUtils.toPossibleList((ReadGraph)graph, (Resource)list);
        if (contexts == null) {
            return null;
        }
        if (graph.isInheritedFrom(type, ISSUE.Sources_DependencyTracker_AnonymousIssue)) {
            return new AnonymousIssue(type, (Collection)contexts);
        }
        return new StandardIssue(type, (Collection)contexts);
    }
}

