/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.issues.Severity;
import org.simantics.issues.common.IssueUtils;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

public class ModelIssuesWithSeverity
extends TernaryRead<Resource, Boolean, Severity, Set<Resource>> {
    public ModelIssuesWithSeverity(Resource model, boolean onlyUnresolved, Severity minSeverity) {
        super((Object)model, (Object)onlyUnresolved, (Object)minSeverity);
    }

    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        THashSet result = new THashSet();
        for (Resource issue : (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)this.parameter, L0.ConsistsOf, ISSUE.Issue))) {
            Severity s;
            if (((Boolean)this.parameter2).booleanValue() && graph.hasStatement(issue, ISSUE.Resolved) || (s = IssueUtils.toSeverity(ISSUE, graph.getPossibleObject(issue, ISSUE.Issue_HasSeverity))).compareTo((Enum)((Severity)this.parameter3)) > 0) continue;
            result.add(issue);
        }
        return result;
    }
}

