/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.QueryMemoryWatcher;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.QueryControl;
import org.simantics.issues.common.BatchIssueSource;
import org.simantics.issues.common.BatchIssueValidationContext;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.scl.db.SCLFunctions;
import org.simantics.scl.runtime.function.Function1;

public class ConstraintIssueSource
implements BatchIssueSource {
    private final Resource resource;

    public ConstraintIssueSource(Resource resource) {
        this.resource = resource;
    }

    @Override
    public Map<Resource, Set<Issue>> run(IProgressMonitor monitor, ReadGraph graph, BatchIssueValidationContext context) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Set emptySet = Collections.emptySet();
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        Map result = (Map)cs.createMap(Set.class);
        monitor.setTaskName("Constraint analysis");
        ModelTransferableGraphSourceRequest.DomainOnlyProcessor domain = context.domain;
        int entityCount = domain.internals.size();
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        Resource type = graph.getSingleType(this.resource, ISSUE.IssueSource);
        ArrayList<Function1> validators = new ArrayList<Function1>();
        for (Resource constraint : graph.getObjects(type, ISSUE.IssueSource_HasConstraint)) {
            Function1 validator = (Function1)graph.getRelatedValue2(constraint, L0.Constraint_Validator, (Object)constraint);
            validators.add(validator);
        }
        QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
        qc.flush(graph);
        QueryMemoryWatcher memory = new QueryMemoryWatcher(graph, 50000, 0.5, 300);
        SCLFunctions.runWithGraph((ReadGraph)graph, () -> {
            int totalExaminedCount = 0;
            int examinedCount = 1000;
            for (Resource r : domainOnlyProcessor.internals) {
                Set set2 = emptySet;
                if (examinedCount >= 1000) {
                    monitor.subTask(ConstraintIssueSource.contextProgressMessage(totalExaminedCount, entityCount));
                    examinedCount = 0;
                    if (monitor.isCanceled()) {
                        return;
                    }
                    memory.maintain();
                }
                for (Function1 validator : validators) {
                    try {
                        List issues = (List)validator.apply((Object)r);
                        if (issues == null || issues.isEmpty()) continue;
                        if (set2 == emptySet) {
                            set2 = new THashSet();
                        }
                        set2.addAll(issues);
                    }
                    catch (Throwable t) {
                        Logger.defaultLogError((Throwable)t);
                    }
                }
                ++totalExaminedCount;
                ++examinedCount;
                if (set2.isEmpty()) continue;
                result.put(r, set2);
            }
        });
        return result;
    }

    private static String contextProgressMessage(int totalExaminedCount, int entityCount) {
        StringBuilder sb = new StringBuilder(80).append("Validating resources").append(" ").append(100 * totalExaminedCount / entityCount).append("% ready.");
        return sb.toString();
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }
}

