/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;
import org.simantics.issues.common.BatchIssueSource;
import org.simantics.issues.common.BatchIssueValidationContext;

public class ComposedValidation
extends UniqueRead<Map<Resource, Set<Issue>>> {
    private final IProgressMonitor monitor;
    private final BatchIssueSource source;
    private final BatchIssueValidationContext context;

    public ComposedValidation(IProgressMonitor monitor, BatchIssueSource source, BatchIssueValidationContext context) {
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
        this.source = source;
        this.context = context;
    }

    public Map<Resource, Set<Issue>> perform(ReadGraph graph) throws DatabaseException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)this.monitor);
        progress.setWorkRemaining(this.context.contexts.size());
        QueryControl cc = (QueryControl)graph.getService(QueryControl.class);
        cc.flush(graph);
        return this.source.run((IProgressMonitor)progress, graph, this.context);
    }
}

