/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.issues.common.ManagedIssues;
import org.simantics.issues.common.StandardIssueDescription;
import org.simantics.issues.ontology.IssueResource;

public class BatchIssueDescriptions
extends ResourceRead2<Set<Issue>> {
    public BatchIssueDescriptions(Resource source, Resource context) {
        super(source, context);
    }

    public Set<Issue> perform(ReadGraph graph) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        Collection issues = (Collection)graph.syncRequest((Read)new ManagedIssues(this.resource));
        if (issues.isEmpty()) {
            return Collections.emptySet();
        }
        THashSet result = new THashSet(issues.size());
        for (Resource issue : issues) {
            Resource list = graph.getSingleObject(issue, ISSUE.Issue_HasContexts);
            if (!ListUtils.toList((ReadGraph)graph, (Resource)list).contains(this.resource2)) continue;
            result.add((Issue)graph.sync((ReadInterface)new StandardIssueDescription(issue)));
        }
        return result;
    }
}

