/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import java.util.Collection;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.Severity;
import org.simantics.issues.ontology.IssueResource;

/**
 * @author Tuukka Lehtonen
 */
public class MaxIssueSeverityRecursive extends TernaryRead<Resource, Resource, Set<Resource>, Severity> {

    public MaxIssueSeverityRecursive(Resource resource, Resource childRelation, Set<Resource> typesToRecurse) {
        super(resource, childRelation, typesToRecurse);
    }
    
    @Override
    public Severity perform(ReadGraph graph) throws DatabaseException {

        IssueResource ISSUE = graph.getService(IssueResource.class);

        Collection<Resource> inv = graph.getObjects(parameter, ISSUE.Issue_HasContext_Inverse);
        Collection<Resource> inv2 = graph.getObjects(parameter, ISSUE.Issue_ContextList_Element_Inverse);
        if(inv.isEmpty() && inv2.isEmpty()) {
            return graph.syncRequest(new ChildMaxIssueSeverity(parameter, parameter2, parameter3));
        }
        
        Severity max = graph.syncRequest(new MaxIssueSeveritySingle(parameter));
        if(max != null)
            return max;
        else
            return graph.syncRequest(new ChildMaxIssueSeverity(parameter, parameter2, parameter3));
            
    }

}
