package org.simantics.issues.common;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.ontology.IssueResource;

public class ManagedIssues extends ResourceRead<Collection<Resource>> {

	public ManagedIssues(Resource source) {
		super(source);
	}
	
	@Override
	public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
		IssueResource IR = IssueResource.getInstance(graph);
		return graph.getObjects(resource, IR.IssueSource_Manages);
	}

	
}
