/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;

import java.util.Set;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 * 
 * @see ErrorIssues
 * @see WarningIssues
 * @see NoteIssues
 * @see FatalIssues
 * @see InfoIssues
 */
public class IssuesOfSeverity extends ResourceRead2<Set<Variable>> {

    public IssuesOfSeverity(Resource project, Resource expectedSeverity) {
        super(project, expectedSeverity);
    }

    protected Resource getExpectedSeverity(ReadGraph graph, IssueResource issue) {
        return resource2;
    }

    @Override
    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {
    	Layer0 L0 = Layer0.getInstance(graph);
        IssueResource ISSUE = IssueResource.getInstance(graph);
        Set<Variable> result = new THashSet<Variable>();
        Resource expectedSeverity = getExpectedSeverity(graph, ISSUE);
        String expectedSeverityName = graph.getRelatedValue(expectedSeverity, L0.HasName, Bindings.STRING);
        assert expectedSeverity != null;
        for (Variable issue : graph.syncRequest(new AllVisibleIssues(resource))) {
            if (expectedSeverityName.equals(issue.getPossiblePropertyValue(graph, "severity")))
                result.add(issue);
        }
        return result;
    }

    public static IssuesOfSeverity error(ReadGraph graph, Resource resource) {
        return new IssuesOfSeverity(resource, IssueResource.getInstance(graph).Severity_Error);
    }

    public static IssuesOfSeverity warning(ReadGraph graph, Resource resource) {
        return new IssuesOfSeverity(resource, IssueResource.getInstance(graph).Severity_Warning);
    }

    public static IssuesOfSeverity fatal(ReadGraph graph, Resource resource) {
        return new IssuesOfSeverity(resource, IssueResource.getInstance(graph).Severity_Fatal);
    }

    public static IssuesOfSeverity info(ReadGraph graph, Resource resource) {
        return new IssuesOfSeverity(resource, IssueResource.getInstance(graph).Severity_Info);
    }

    public static IssuesOfSeverity note(ReadGraph graph, Resource resource) {
        return new IssuesOfSeverity(resource, IssueResource.getInstance(graph).Severity_Note);
    }

}
