/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.Severity;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 * @see CountModelIssuesWithSeverity
 */
public class CountModelIssuesBySeverity extends TernaryRead<Resource, Boolean, Severity, TObjectIntMap<Severity>> {

    public CountModelIssuesBySeverity(Resource model, boolean onlyUnresolved, Severity minSeverity) {
        super(model, onlyUnresolved, minSeverity);
    }

    @Override
    public TObjectIntMap<Severity> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        IssueResource ISSUE = IssueResource.getInstance(graph);

        TObjectIntMap<Severity> result = new TObjectIntHashMap<Severity>();
        for (Resource issue : graph.syncRequest(new ObjectsWithType(parameter, L0.ConsistsOf, ISSUE.Issue))) {
            if (parameter2 && graph.hasStatement(issue, ISSUE.Resolved))
                continue;
            Severity s = IssueUtils.toSeverity(ISSUE, graph.getPossibleObject(issue, ISSUE.Issue_HasSeverity));
            if (null != s && s.compareTo(parameter3) <= 0)
                result.adjustOrPutValue(s, 1, 1);
        }
        return result;
    }

}
