/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.service.CollectionSupport;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

/**
 * @author Antti Villberg
 */
public class AllIssues extends BinaryRead<Resource, Boolean, Set<Resource>> {

    public AllIssues(Resource project) {
        super(project, Boolean.FALSE);
    }

    public AllIssues(Resource project, boolean onlyUnresolved) {
        super(project, onlyUnresolved);
    }
    
    public void collectIssuesFrom(ReadGraph graph, Resource container, Set<Resource> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        IssueResource ISSUE = IssueResource.getInstance(graph);
        for (Resource issue : graph.syncRequest(new ObjectsWithType(container, L0.ConsistsOf, ISSUE.Issue))) {
            if (parameter2 && graph.hasStatement(issue, ISSUE.Resolved))
                continue;
            result.add(issue);
        }
    }

    @Override
    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        IssueResource ISSUE = IssueResource.getInstance(graph);
        SimulationResource SIMU = SimulationResource.getInstance(graph);
        CollectionSupport cs = graph.getService(CollectionSupport.class);
        Set<Resource> result = cs.createSet();
        Instances indexedIssues = graph.getPossibleAdapter(ISSUE.Issue, Instances.class);
        for (Resource model : graph.syncRequest(new ObjectsWithType(parameter, L0.ConsistsOf, SIMU.Model))) {
        	collectIssuesFrom(graph, model, result);
        	for (Resource source : graph.syncRequest(new ObjectsWithType(parameter, L0.ConsistsOf, ISSUE.IssueSource))) {
            	collectIssuesFrom(graph, source, result);
        	}
            if (indexedIssues != null)
                result.addAll(indexedIssues.find(graph, model));
        }
        return result;
    }

}
