package org.simantics.issues.common;

import java.util.Collections;
import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.function.Function1;

public class All {
	
    @SCLValue(type = "ReadGraph -> Resource -> Variable -> String")
    public static String defaultDescription(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
    	return context.getParent(graph).getLabel(graph);
    }
    
    @SCLValue(type = "a -> b -> c")
    public static Object dependencyBaseRealizationFunction(Object _graph, Object _model) throws DatabaseException {
//        ReadGraph graph = (ReadGraph)_graph;
        Resource model = (Resource)_model;
        return model;
//        SimulationResource SIMU = SimulationResource.getInstance(graph);
//        if(graph.isInstanceOf(model, SIMU.Model))
//            return graph.getSingleObject(model, SimulationResource.getInstance(graph).HasConfiguration);
//        else return null;

    }
    
    @SCLValue(type = "ReadGraph -> Resource -> Variable -> String")
    public static String standardIssueSeverity(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
    	Layer0 L0 = Layer0.getInstance(graph);
    	IssueResource ISSUE = IssueResource.getInstance(graph);
    	Resource issue = property.getParent(graph).getRepresents(graph);
    	Resource severity = graph.getPossibleObject(issue, ISSUE.Issue_HasSeverity);
    	if (severity == null)
    		return "Undefined";
    	return graph.getPossibleRelatedValue(severity, L0.HasName, Bindings.STRING);
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> String")
    public static String standardIssueResource(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
    	Layer0 L0 = Layer0.getInstance(graph);
    	List<Resource> contexts = IssueUtils.getContextsForProperty(graph, property);
    	if(contexts.isEmpty()) return "";
    	Resource context = contexts.get(0);
    	String name = graph.getPossibleRelatedValue(context, L0.HasName, Bindings.STRING);
    	if((name != null && !name.isEmpty())) return name;
    	if(!graph.hasStatement(context)) return "Removed - please run batch validations";
    	return context.toString();
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> String")
    public static String standardIssuePath(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
    	Layer0 L0 = Layer0.getInstance(graph);
    	List<Resource> contexts = IssueUtils.getContextsForProperty(graph, property);
    	if(contexts.isEmpty()) return "";
    	Resource parent = graph.getPossibleObject(contexts.get(0), L0.PartOf);
    	if(parent == null) return "";
    	Resource issueRoot = Variables.getPossibleIndexRoot(graph, property);
    	if(issueRoot == null) return "";
    	Resource contextRoot = graph.sync(new PossibleIndexRoot(parent));
    	if(contextRoot == null) return "";
    	if(issueRoot.equals(contextRoot)) {
        	String uri = graph.getURI(parent);
        	String contextURI = graph.getURI(contextRoot);
        	if (uri.equals(contextURI)) return "";
        	return IssueUtils.pathString(uri, contextURI.length()+1);
    	} else {
        	String uri = graph.getURI(parent);
        	String modelURI = graph.getURI(graph.getRootLibrary());
    		return IssueUtils.pathString(uri, modelURI.length()+1);
    	}
    }

    @SCLValue(type = "ReadGraph -> Resource -> a -> [Resource]")
    public static List<Resource> standardIssueContexts(ReadGraph graph, Resource converter, Object property) throws DatabaseException {
        if (property instanceof Variable) {
            return IssueUtils.getContextsForProperty(graph, (Variable) property);
        } else if (property instanceof Resource) {
            Resource issue = (Resource) property;
            IssueResource ISSUE = IssueResource.getInstance(graph);
            Resource list = graph.getPossibleObject(issue, ISSUE.Issue_HasContexts);
            if(list != null)
                return ListUtils.toList(graph, list);
            else
                return Collections.emptyList();
        }
        throw new IllegalArgumentException("Unsupported property type: " + property);
    }

    @SCLValue(type = "ReadGraph -> Resource -> a -> b")
    public static Function1<Boolean, Boolean> standardIssueHider(ReadGraph graph, Resource converter, Object property) throws DatabaseException {
        if (property instanceof Variable) {
            Variable hider = (Variable) property;
            Variable issue = hider.getParent(graph);
            Resource r = issue.getPossibleRepresents(graph);
            if (r != null)
                return new HideFunction(r);
        }
        return null;
    }

    @SCLValue(type = "ReadGraph -> Resource -> a -> Boolean")
    public static Boolean standardIssueHidden(ReadGraph graph, Resource converter, Object property) throws DatabaseException {
        if (property instanceof Variable) {
            Variable hidden = (Variable) property;
            Variable issue = hidden.getParent(graph);
            Resource r = issue.getPossibleRepresents(graph);
            if (r != null) {
                IssueResource ISSUE = IssueResource.getInstance(graph);
                return graph.hasStatement(r, ISSUE.Hidden);
            }
        }
        return false;
    }

}
