/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.csv;

class URIs {
    URIs() {
    }

    public static String safeUnescape(String uri) {
        try {
            return URIs.unescape(uri);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return uri;
        }
    }

    public static String unescape(String uri) {
        try {
            if (!URIs.needsUnescaping(uri)) {
                return uri;
            }
            int len = uri.length();
            String unicode = uri;
            char[] result = new char[len];
            int in = 0;
            int out = 0;
            while (in < len) {
                char inCh;
                if ((inCh = unicode.charAt(in++)) == '%' && in + 1 < len) {
                    char d1 = unicode.charAt(in);
                    char d2 = unicode.charAt(in + 1);
                    if (d1 > '\u007f' || d2 > '\u007f') {
                        throw new IllegalArgumentException("Invalid hex digit escape sequence in " + uri + " at " + in);
                    }
                    result[out++] = (char)(URIs.hexDecode(d1) * 16 | URIs.hexDecode(d2));
                    in += 2;
                    continue;
                }
                result[out++] = inCh;
            }
            return new String(result, 0, out);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Problem while unescaping string: " + uri, e);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Incomplete hex digit escape sequence in " + uri);
        }
    }

    private static boolean needsUnescaping(String s) {
        int l = s.length();
        int i = -1;
        while (i < l) {
            if ((i = s.indexOf(37, i + 1)) < 0) break;
            if (i + 2 >= l || !URIs.isHexDigit(s.charAt(i + 1)) || !URIs.isHexDigit(s.charAt(i + 2))) continue;
            return true;
        }
        return false;
    }

    private static int hexDecode(char c) {
        switch (c) {
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return (c & 0xFF) - 97 + 10;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c - 65 + 10;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
        }
        throw new IllegalArgumentException("Bad Hex escape character: " + (c & 0xFF));
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }
}

