/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history;

import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.history.Collector;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.util.StreamIterator;

public class HistorySamplerItem
implements Comparable<HistorySamplerItem> {
    Collector collector;
    HistoryManager history;
    String historyItemId;
    StreamAccessor accessor;
    public StreamIterator iter;
    public int chartDataId;

    public HistorySamplerItem(Collector collector, HistoryManager history, String historyItemId, int identityHashCode) {
        this.collector = collector;
        this.history = history;
        this.historyItemId = historyItemId;
        this.chartDataId = identityHashCode;
    }

    public void open() throws HistoryException {
        this.accessor = this.history.openStream(this.historyItemId, "r");
        this.iter = new StreamIterator((ArrayAccessor)this.accessor);
    }

    public void close() {
        if (this.accessor != null) {
            try {
                this.accessor.close();
            }
            catch (AccessorException accessorException) {}
        }
        this.accessor = null;
        this.iter = null;
    }

    @Override
    public int compareTo(HistorySamplerItem o) {
        int i = this.historyItemId.compareTo(o.historyItemId);
        if (i != 0) {
            return i;
        }
        return 0;
    }

    public int hashCode() {
        int code = 8964;
        code = 13 * code + this.historyItemId.hashCode();
        code = 13 * code + this.history.hashCode();
        return code;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistorySamplerItem)) {
            return false;
        }
        HistorySamplerItem other = (HistorySamplerItem)obj;
        if (!other.history.equals(this.history)) {
            return false;
        }
        return other.historyItemId.equals(this.historyItemId);
    }
}

