/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.history.test;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.history.util.ValueBand;

/**
 * Which is faster binding to use? 
 * 
 *    1. Write to record with reflection
 *    
 *    
 *    
 *    2. Write to object array with boxed primitives 
 *    
 *    
 *
 */
public class TestBindingPerformance {
	
	public static class Sample {
		public double time, endTime, value, lastValue, min, max, avg, median;
		public byte quality;
		public int count;
	}	
	
	public static void test( Binding b ) throws Exception {
		
		Object s = b.createDefault();
		ValueBand band = new ValueBand( b, s );
				
		for (int i=0; i<10000000; i++) {
			double value = i;
			band.setTime(Bindings.DOUBLE, value);
			band.setEndTime(Bindings.DOUBLE, value);
			band.setValue(Bindings.DOUBLE, value);
			band.setLastValue(Bindings.DOUBLE, value);
			band.setMin(Bindings.DOUBLE, value);
			band.setMax(Bindings.DOUBLE, value);
			band.setAvg(Bindings.DOUBLE, value);
			band.setMedian(Bindings.DOUBLE, value);
		}
		
	}
	
	public static void main(String[] args) throws Exception {
		
		Binding b1 = Bindings.getBinding( Sample.class );
		Binding b2 = Bindings.getBinding( b1.type() );
		
		test(b1);
		test(b2);
		
		long ct = System.currentTimeMillis();
		test(b1);
		System.out.println(System.currentTimeMillis()-ct);

		ct = System.currentTimeMillis();
		test(b2);
		System.out.println(System.currentTimeMillis()-ct);
		
	}

}
