/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.history.util;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.reflection.BindingProvider;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.binding.reflection.ClassBindingFactory;
import org.simantics.databoard.type.ArrayType;

public class MedianBindingProvider implements BindingProvider {
	
	public static MedianBindingProvider INSTANCE = new MedianBindingProvider();

	public Binding provideBinding(ClassBindingFactory master, BindingRequest request) throws BindingConstructionException {
		if (WeightedMedian.class.isAssignableFrom( request.getClazz() )) {
			return new WeightedMedianBinding();
		}
		if (Median.class.isAssignableFrom( request.getClazz() )) { 
			return new MedianBinding(new ArrayType(null), null);
		}
		return null;
	}

}
