/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.history.impl;

import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Identifier;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.history.util.MedianBindingProvider;
import org.simantics.history.util.WeightedMedian;

/**
 * This is the state that s persisted.
 *  
 * @author toni.kalajainen
 */
public class CollectorState extends Bean {

	public static final Binding BINDING = Bindings.getBindingUnchecked( CollectorState.class );
	public static final Binding BINDING_ITEM = Bindings.getBindingUnchecked( CollectorState.Item.class );
	
	public @Identifier String id;
	
	/** Last known time value */
	public MutableVariant time;

	/** Time stepped between the two last collector steps. Used for time stamp epsilon calculations. */
	public double dT = 1.0;

	/** Last known values for each variable */
	public Map<String, VariableState> values;
	 
	/** Item states - corresponds to subscription.items */
	public Map<String, Item> itemStates;

	public static class VariableState {
		
		/** The actual value, type is Void if no value */
		public MutableVariant value;
		
		/** Set to true if is valid value */
		public boolean isValid; 
		
		/** True, if double or float and is NaN */
		public boolean isNan;
	}
	
	public static class Item extends Bean {
		
		// Subscription info
		/** History item reference */
		public @Identifier String id;
		/** Datasource reference */
		public String variableId;
		/** Dataformat */
		public Datatype format;
		/** Deadband */
		public double deadband = Double.NaN;
		/** Interval */
		public double interval = Double.NaN;
		/** Gain */
		public double gain = 1.0;
		/** Bias */
		public double bias = 0.0;
		/** Enabled */
		public boolean enabled = true;
		/** Format id, group id */
		public String groupId = "", groupItemId = "", formatId = "";
		
		// - Valueband 	
		/** Time of the first sample in the value band. NAN, if there is no value */
		public double firstTime = Double.NaN;
		/** Value of the first sample in the value band. null, if there is no value */
		public MutableVariant firstValue;
		/** Time of the prev added sample. NAN, if there is no value */
		public double currentTime;
		/** Value of the prev added sample. null, if there is no value */
		public MutableVariant currentValue;
		/** Current value is NaN */
		public boolean isNaN;
		/** Current value is valid */
		public boolean isValid;
		/** Time weighted sum (area), NAN, if not accumulated */
		public double sum;
		/** Sample Count of acquired samples in current band */
		public int count;
		/** Out of dead band, set true if a sample has crossed the deadband region in this value band */
		public boolean ooDeadband = false;
		/** First time after disabled */
		public double firstDisabledTime;
		/** Last time while disabled*/
		public double lastDisabledTime;
		/** Is item currently disabled */
		public boolean isDisabled;
		
		/** Median values of the value band */
		public WeightedMedian median;
		
		/**
		 * Interval is the time between two samples, a step length.  
		 * Distribution contains classification of their variation. It is of 
		 * interest if the datasource contains varying sizes and a mipmap interval 
		 * needs to be decided. Null, if not breakdown is not constructed. 
		 */ 	
		//public @Optional ClassDistribution intervalDistribution;
		
		/**
		 * Value distribution contains clasification of values. 
		 */
		//public @Optional ClassDistribution valueDistribution;

	}
	
	public CollectorState() {
		super(BINDING);
	}
	
	static {
    	Bindings.classBindingFactory.addFactory( MedianBindingProvider.INSTANCE );
    	
		try {
	    	BindingRequest br = new BindingRequest( CollectorState.Item.class ); 
	    	Binding datatypeBinding = Bindings.getBinding( br );
	    	Bindings.typeClassFactory.getRepository().put(datatypeBinding.type(), br);    	
	    	
	    	br = new BindingRequest( CollectorState.class ); 
	    	datatypeBinding = Bindings.getBinding( br );
	    	Bindings.typeClassFactory.getRepository().put(datatypeBinding.type(), br);
	    	
		} catch (BindingConstructionException e) {
			System.err.println(e);
		}
	}
	
}
