package org.simantics.history.csv;


public enum ColumnSeparator {
	COMMA("Comma (,)", ","),TAB("Tabulator (\\t)","\t"),SEMICOLON("Semicolon (;)",";"),COLON("Colon (:)",":"),SPACE("Space ( )", " ");
	public String label;
	public String preference;
	ColumnSeparator(String label, String preference) {
		this.label = label;
		this.preference = preference;
	}
	public static ColumnSeparator fromIndex(int index) {
		return values()[index];
	}
	public String toPreference() {
		return preference;
	}
	public static ColumnSeparator fromPreference(String preference) {
		for(ColumnSeparator s : values()) {
			if(s.preference.equals(preference)) return s;
		}
		return COMMA;
	}
}