package org.simantics.history;

import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.history.util.StreamIterator;

public class HistorySamplerItem implements Comparable<HistorySamplerItem> {
	
	Collector collector;
	HistoryManager history;         // History source for this item
	String historyItemId;

	// State data
	StreamAccessor accessor;			// Stream accessor
	public StreamIterator iter;
    public int chartDataId;
	
	public HistorySamplerItem(Collector collector, HistoryManager history, String historyItemId, int identityHashCode) {
		this.collector = collector;
		this.history = history;
		this.historyItemId = historyItemId;
		this.chartDataId = identityHashCode;
	}
	
	public void open() throws HistoryException {
		accessor = history.openStream(historyItemId, "r");
		iter = new StreamIterator( accessor );
	}
	
	public void close() {
		if (accessor!=null) {
			try {
				accessor.close();
			} catch (AccessorException e) {
			}
		}
		accessor = null;
		iter = null;
	}

	@Override
	public int compareTo(HistorySamplerItem o) {
		int i;
		i = historyItemId.compareTo(o.historyItemId);			
		if (i!=0) return i;
		return 0;
	}
	
	@Override
	public int hashCode() {
		int code = 0x2304;
		code = 13*code + historyItemId.hashCode();
		code = 13*code + history.hashCode();			
		return code;
	}
	
	@Override
	public boolean equals(Object obj) {
		if ( obj == null ) return false;
		if ( obj instanceof HistorySamplerItem == false ) return false;
		HistorySamplerItem other = (HistorySamplerItem) obj;			
		if ( !other.history.equals(history) ) return false;
		if ( !other.historyItemId.equals(historyItemId) ) return false;
		return true;
	}
	
}
