/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.resourceFiles;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.graph.IResourceFile;
import org.simantics.graph.compiler.internal.resourceFiles.ResourceFile;
import org.simantics.graph.compiler.internal.resourceFiles.ResourceRef;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.PathChild;
import org.simantics.graph.query.Paths;
import org.simantics.graph.store.GraphStore;

public class ResourceFileGenerator {
    static THashSet<String> KEYWORDS = new THashSet();

    static {
        String[] stringArray = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "true", "false", "null"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            KEYWORDS.add((Object)s);
            ++n2;
        }
    }

    public static Collection<IResourceFile> generate(Paths paths, GraphStore store) {
        int HasResourceClass = store.identities.pathToId(paths.HasResourceClass);
        if (HasResourceClass < 0) {
            return Collections.emptyList();
        }
        ArrayList<IResourceFile> result = new ArrayList<IResourceFile>();
        int resourceCount = store.identities.getResourceCount();
        int ontology = 0;
        while (ontology < resourceCount) {
            int[] nArray = store.statements.getObjects(ontology, HasResourceClass).toArray();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int v = nArray[n2];
                Variant value = store.values.getByteValue(v);
                if (value != null) {
                    try {
                        String className = (String)value.getValue((Binding)Bindings.STRING);
                        result.add(ResourceFileGenerator.generate(paths, store, ontology, className));
                    }
                    catch (AdaptException adaptException) {}
                }
                ++n2;
            }
            ++ontology;
        }
        return result;
    }

    private static ResourceFile generate(Paths paths, GraphStore store, int ontology, String fullClassName) {
        String className;
        String packageName;
        int p = fullClassName.lastIndexOf(46);
        if (p > 0) {
            packageName = fullClassName.substring(0, p);
            className = fullClassName.substring(p + 1);
        } else {
            packageName = "";
            className = fullClassName;
        }
        ArrayList<ResourceRef> resources = new ArrayList<ResourceRef>();
        ResourceFileGenerator.findResources(store, store.identities.pathToId(paths.Deprecated), store.identities.idToPath(ontology), ontology, resources);
        ResourceFile file = new ResourceFile(packageName, className, resources);
        file.sort();
        return file;
    }

    private static void findResources(GraphStore store, int deprecatedId, Path root, int parent, List<ResourceRef> resources) {
        int[] nArray = store.identities.getChildren(parent);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int child = nArray[n2];
            ResourceRef ref = ResourceFileGenerator.createResource(root, store.identities.idToPath(child));
            if (!store.statements.getObjects(child, deprecatedId).isEmpty()) {
                ref.deprecated = true;
            }
            resources.add(ref);
            ResourceFileGenerator.findResources(store, deprecatedId, root, child, resources);
            ++n2;
        }
    }

    private static ResourceRef createResource(Path root, Path path) {
        StringBuilder b = new StringBuilder();
        ResourceFileGenerator.javaName(b, root, path);
        Object javaName = b.toString();
        if (KEYWORDS.contains(javaName)) {
            javaName = (String)javaName + "_";
        } else if (!Character.isJavaIdentifierStart(((String)javaName).charAt(0))) {
            javaName = "_" + (String)javaName;
        }
        return new ResourceRef((String)javaName, path.toString());
    }

    private static void javaName(StringBuilder b, Path root, Path path) {
        if (!root.equals(path)) {
            PathChild pc = (PathChild)path;
            ResourceFileGenerator.javaName(b, root, pc.parent);
            if (b.length() > 0) {
                b.append('_');
            }
            int i = 0;
            while (i < pc.name.length()) {
                char c = pc.name.charAt(i);
                if (Character.isJavaIdentifierPart(c)) {
                    b.append(c);
                } else if (c == ' ') {
                    b.append('_');
                } else {
                    b.append('$');
                }
                ++i;
            }
        }
    }
}

