/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.resourceFiles;

import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.graph.IResourceFile;
import org.simantics.graph.compiler.internal.resourceFiles.FilterCRWriter;
import org.simantics.graph.compiler.internal.resourceFiles.ResourceRef;

public class ResourceFile
implements IResourceFile {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    String packageName;
    String className;
    List<ResourceRef> resources;
    private static Configuration configuration = null;

    public ResourceFile(String packageName, String className, List<ResourceRef> resources) {
        this.packageName = packageName;
        this.className = className;
        this.resources = resources;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public Collection<ResourceRef> getResources() {
        return this.resources;
    }

    private static Configuration getConfiguration() {
        if (configuration == null) {
            configuration = new Configuration();
            configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

                protected URL getURL(String name) {
                    return ResourceFile.class.getResource(name);
                }
            });
            configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        }
        return configuration;
    }

    public void write(Writer writer) {
        try {
            Template temp = ResourceFile.getConfiguration().getTemplate("resourceFile.ftl");
            temp.process((Object)this, writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InputStream getContent() {
        StringWriter writer = new StringWriter();
        this.write(String.format("%n", new Object[0]).length() == 1 ? new FilterCRWriter(writer) : writer);
        return new ByteArrayInputStream(writer.toString().getBytes(UTF8));
    }

    public String getFileName() {
        return "src/" + this.packageName.replace('.', '/') + "/" + this.className + ".java";
    }

    public void sort() {
        Collections.sort(this.resources);
    }

    public static void main(String[] args) {
        System.out.println(String.format("%n", new Object[0]).length());
    }
}

