/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.procedures;

import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.graph.compiler.internal.ltk.Location;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.compiler.internal.store.LocationStore;
import org.simantics.graph.compiler.internal.templates.TemplateDefinition;
import org.simantics.graph.compiler.internal.templates.TemplateDefinitionStore;
import org.simantics.graph.query.CompositeGraph;
import org.simantics.graph.query.Paths;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.store.GraphStore;

public class CreateTemplates
implements Runnable {
    CompositeGraph graph;
    GraphStore store;
    Collection<Problem> problems;
    int HasTemplate;
    int HasTemplateParameters;
    int InstanceOf;
    int StringArray;
    int Graph;

    public CreateTemplates(CompositeGraph graph, GraphStore store, Collection<Problem> problems) {
        this.graph = graph;
        this.store = store;
        this.problems = problems;
    }

    @Override
    public void run() {
        TemplateDefinitionStore templateStore = (TemplateDefinitionStore)this.store.getStore(TemplateDefinitionStore.class);
        if (templateStore == null || templateStore.isEmpty()) {
            return;
        }
        Paths paths = this.graph.getPaths();
        this.HasTemplate = this.store.identities.createPathToId(paths.HasTemplate);
        this.HasTemplateParameters = this.store.identities.createPathToId(paths.HasTemplateParameters);
        this.InstanceOf = this.store.identities.createPathToId(paths.InstanceOf);
        this.StringArray = this.store.identities.createPathToId(paths.StringArray);
        this.Graph = this.store.identities.createPathToId(paths.Graph);
        templateStore.forTemplateDefinitions(new TIntObjectProcedure<TemplateDefinition>(){

            public boolean execute(int templateId, TemplateDefinition template) {
                if (CreateTemplates.this.validateTemplate(templateId, template)) {
                    CreateTemplates.this.writeTemplate(templateId, template);
                }
                return true;
            }
        });
    }

    private boolean validateTemplate(int templateId, TemplateDefinition template) {
        THashSet parameters = new THashSet();
        parameters.add((Object)"");
        String[] stringArray = template.getParameters();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            parameters.add((Object)parameter);
            ++n2;
        }
        boolean isValid = true;
        GraphStore templateStore = template.getTemplate();
        String[] stringArray2 = templateStore.identities.getRoots();
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            String root = stringArray2[n4];
            if (!parameters.contains((Object)root)) {
                Location location;
                LocationStore templateLocations = (LocationStore)templateStore.getStore(LocationStore.class);
                Location location2 = location = templateLocations == null ? null : templateLocations.getLocation(templateStore.identities.getRoot(root));
                if (location == null) {
                    LocationStore locations = (LocationStore)this.store.getStore(LocationStore.class);
                    location = locations == null ? null : locations.getLocation(templateId);
                }
                this.problems.add(new Problem(location, "Graph template does not have parameter %" + root + "."));
                isValid = false;
            }
            ++n4;
        }
        return isValid;
    }

    private void writeTemplate(int templateId, TemplateDefinition template) {
        TransferableGraph1 tg = template.convert(this.graph, this.store, this.problems);
        int templateValue = this.store.identities.newResource();
        this.store.values.setValue(templateValue, new Variant(TransferableGraph1.BINDING, (Object)tg));
        this.store.statements.add(templateId, this.HasTemplate, templateValue);
        this.store.statements.add(templateValue, this.InstanceOf, this.Graph);
        int parameters = this.store.identities.newResource();
        this.store.values.setValue(parameters, new Variant((Binding)Bindings.STRING_ARRAY, (Object)template.getParameters()));
        this.store.statements.add(templateId, this.HasTemplateParameters, parameters);
        this.store.statements.add(parameters, this.InstanceOf, this.StringArray);
    }
}

