/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.procedures;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.query.Paths;
import org.simantics.graph.query.Res;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.StatementStore;

public class CreateInverseRelations
implements Runnable {
    IGraph graph;
    GraphStore store;

    public CreateInverseRelations(IGraph graph, GraphStore store) {
        this.graph = graph;
        this.store = store;
    }

    @Override
    public void run() {
        Paths paths = this.graph.getPaths();
        int subrelationOf = this.store.identities.pathToId(paths.SubrelationOf);
        if (subrelationOf < 0) {
            return;
        }
        int inverseOf = this.store.identities.createPathToId(paths.InverseOf);
        int resourceCount = this.store.identities.getResourceCount();
        TIntIntHashMap inverseMap = new TIntIntHashMap();
        StatementStore statements = this.store.statements;
        int id = 0;
        while (id < resourceCount) {
            TIntArrayList objects = statements.getObjects(id, inverseOf);
            if (!objects.isEmpty()) {
                inverseMap.put(id, objects.get(0));
                int i = 0;
                while (i < objects.size()) {
                    inverseMap.put(objects.get(i), id);
                    ++i;
                }
            }
            ++id;
        }
        boolean mod = true;
        while (mod) {
            mod = false;
            int id2 = 0;
            while (id2 < resourceCount) {
                if (this.store.identities.isNewResource(id2) || !this.store.identities.hasIdentity(id2)) {
                    TIntArrayList superrelations = this.store.statements.getObjects(id2, subrelationOf);
                    TIntArrayList invSuperrelations = new TIntArrayList(superrelations.size());
                    int[] nArray = superrelations.toArray();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int superrelation = nArray[n2];
                        for (Res invSuperrelation : this.graph.rawGetObjects(this.store.idToRes(superrelation), (Res)paths.InverseOf)) {
                            invSuperrelations.add(this.store.createResToId(invSuperrelation));
                        }
                        ++n2;
                    }
                    if (!invSuperrelations.isEmpty()) {
                        int[] nArray2;
                        int inverse;
                        if (!inverseMap.containsKey(id2)) {
                            if (this.store.identities.hasIdentity(id2)) {
                                inverse = this.store.identities.getChild(id2, "Inverse");
                                this.store.identities.markNew(inverse);
                            } else {
                                inverse = this.store.identities.newResource();
                            }
                            inverseMap.put(id2, inverse);
                            inverseMap.put(inverse, id2);
                            this.store.statements.add(id2, inverseOf, inverse);
                            mod = true;
                        } else {
                            inverse = inverseMap.get(id2);
                            nArray2 = this.store.statements.getObjects(inverse, subrelationOf).toArray();
                            int n3 = nArray2.length;
                            n = 0;
                            while (n < n3) {
                                int curSuperrelation = nArray2[n];
                                int i = invSuperrelations.indexOf(curSuperrelation);
                                if (i >= 0) {
                                    invSuperrelations.set(i, invSuperrelations.get(invSuperrelations.size() - 1));
                                    invSuperrelations.removeAt(invSuperrelations.size() - 1);
                                }
                                ++n;
                            }
                        }
                        nArray2 = invSuperrelations.toArray();
                        int n4 = nArray2.length;
                        n = 0;
                        while (n < n4) {
                            int invSuperrelation = nArray2[n];
                            this.store.statements.add(inverse, subrelationOf, invSuperrelation);
                            ++n;
                        }
                    }
                }
                ++id2;
            }
        }
    }
}

