/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.parsing;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.Tree;
import org.simantics.graph.compiler.SourceInfo;
import org.simantics.graph.compiler.internal.ltk.ISource;
import org.simantics.graph.compiler.internal.ltk.Location;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.compiler.internal.ltk.SourcePart;
import org.simantics.graph.compiler.internal.ltk.antlr.ANTLRUtils;
import org.simantics.graph.compiler.internal.parsing.GraphLexer;
import org.simantics.graph.compiler.internal.parsing.GraphParser;
import org.simantics.graph.compiler.internal.parsing.SourceSplitter;
import org.simantics.graph.compiler.internal.store.VariableStore;
import org.simantics.graph.compiler.internal.translation.GraphTranslator;
import org.simantics.graph.query.Paths;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.IStore;
import org.simantics.graph.utils.GraphExecutor;

public class Parsing
implements Runnable {
    Collection<ISource> sources;
    Collection<Problem> errors;
    GraphStore store;
    Paths paths;

    public Parsing(Paths paths, Collection<ISource> sources, Collection<Problem> errors, GraphStore store) {
        this.paths = paths;
        this.sources = sources;
        this.errors = errors;
        this.store = store;
    }

    public static byte[] read(ISource source) throws IOException {
        int count;
        int length = source.length();
        if (length >= 0) {
            byte[] buffer = new byte[length];
            InputStream stream = source.open();
            int pos = 0;
            while (pos < buffer.length) {
                int c = stream.read(buffer, pos, buffer.length - pos);
                if (c <= 0) break;
                pos += c;
            }
            stream.close();
            return buffer;
        }
        byte[] buffer = new byte[1024];
        InputStream stream = source.open();
        int pos = 0;
        while ((count = stream.read(buffer, pos, buffer.length - pos)) > 0) {
            if ((pos += count) != buffer.length) continue;
            buffer = Arrays.copyOf(buffer, buffer.length * 2);
        }
        stream.close();
        if (pos < buffer.length) {
            buffer = Arrays.copyOf(buffer, pos);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block11: {
            try {
                orderedSources = new ArrayList<ISource>(this.sources);
                Collections.sort(orderedSources, new Comparator<ISource>(){

                    @Override
                    public int compare(ISource o1, ISource o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                parsingFutures = new ArrayList<Future<ParsingResult>>();
                for (ISource source : orderedSources) {
                    sourceString = new String(Parsing.read(source), "UTF-8");
                    splitPoints = SourceSplitter.split(sourceString, 6400);
                    i = 1;
                    while (i < splitPoints.size()) {
                        begin = splitPoints.get(i - 1);
                        end = splitPoints.get(i);
                        sourcePartString = sourceString.substring(begin.characterId, end.characterId);
                        sourcePart = new SourcePart(source, begin.characterId, begin.lineId);
                        parsingFutures.add(GraphExecutor.EXECUTOR.submit(new Callable<ParsingResult>(){

                            @Override
                            public ParsingResult call() throws Exception {
                                ANTLRStringStream stream = new ANTLRStringStream(sourcePartString);
                                GraphLexer lexer = new GraphLexer((CharStream)stream){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void reportError(RecognitionException e) {
                                        Collection<Problem> collection = (this).Parsing.this.errors;
                                        synchronized (collection) {
                                            (this).Parsing.this.errors.add(ANTLRUtils.error((ISource)sourcePart, e, this));
                                        }
                                    }
                                };
                                CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
                                GraphParser parser = new GraphParser((TokenStream)tokenStream){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void reportError(RecognitionException e) {
                                        Collection<Problem> collection = (this).Parsing.this.errors;
                                        synchronized (collection) {
                                            (this).Parsing.this.errors.add(ANTLRUtils.error((ISource)sourcePart, e, this));
                                        }
                                    }
                                };
                                GraphParser.file_return result = parser.file();
                                if (!Parsing.this.errors.isEmpty()) {
                                    return null;
                                }
                                return new ParsingResult(sourcePart, (Tree)result.getTree());
                            }
                        }));
                        ++i;
                    }
                }
                translators = new THashMap();
                for (Future future : parsingFutures) {
                    result = (ParsingResult)future.get();
                    i = this.errors;
                    synchronized (i) {
                        if (!this.errors.isEmpty()) {
                            continue;
                        }
                    }
                    originalSource = ((SourcePart)result.source).getOriginalSource();
                    translator = (GraphTranslator)translators.get((Object)originalSource);
                    if (translator == null) {
                        translator = new GraphTranslator(this.paths, this.errors, this.store);
                        translators.put((Object)originalSource, (Object)translator);
                    }
                    translator.setSource(result.source);
                    translator.translateGraph(result.tree);
                }
                variableStore = new VariableStore();
                this.store.addStore(VariableStore.class, (IStore)variableStore);
                translators.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<ISource, GraphTranslator>(){

                    public boolean execute(ISource a, GraphTranslator b) {
                        final ArrayList<SourceInfo.Variable> variables = new ArrayList<SourceInfo.Variable>();
                        b.getVariables().forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

                            public boolean execute(String a, int b) {
                                variables.add(new SourceInfo.Variable(a, b));
                                return true;
                            }
                        });
                        variableStore.addSourceFile(new SourceInfo.SourceFile(a.getName(), variables, b.getDefinitionPositions()));
                        return true;
                    }
                });
                break block11;
            }
            catch (Exception e) {
                e.printStackTrace();
                stream = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stream));
                description = "Internal error: " + new String(stream.toByteArray());
                ** for (source : this.sources)
            }
lbl-1000:
            // 1 sources

            {
                this.errors.add(new Problem(new Location(source), description));
                continue;
            }
        }
    }

    private static class ParsingResult {
        ISource source;
        Tree tree;

        public ParsingResult(ISource source, Tree tree) {
            this.source = source;
            this.tree = tree;
        }
    }
}

