package org.simantics.graph.compiler.internal.translation;

import gnu.trove.list.array.TIntArrayList;

import org.antlr.runtime.tree.Tree;
import org.simantics.graph.store.GraphStore;

public class ChildGraphTranslator extends GraphTranslator {

	TIntArrayList correspondences = new TIntArrayList();	
	GraphTranslator parent;
		
	public ChildGraphTranslator(GraphTranslator parent, GraphStore store) {
		super(parent.paths, parent.problems, store);
		this.parent = parent;
	}

	@Override
	public int getVariable(Tree place, String text) {
		if(variables.containsKey(text))
			return variables.get(text);
		else {
			correspondences.add(parent.getVariable(place, text));			
			int id = identities.newResource();
			correspondences.add(id);
			variables.put(text, id);		
			locate(id, place);
			return id;
		}
	}	
	
	public int[] getCorrespondences() {
		return correspondences.toArray();
	}
}
