package org.simantics.graph.compiler.internal.templates;

import java.util.Collection;

import org.simantics.graph.compiler.ExternalFileLoader;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.query.Paths;
import org.simantics.graph.store.GraphStore;

public enum ListTemplate implements ITemplate {
	
	INSTANCE;
	
	@Override
	public void apply(IGraph graph, GraphStore store,
			int[] parameters, ExternalFileLoader fileLoader, Collection<Problem> problems) {
		createList(graph.getPaths(), store, parameters);
	}
	
	public static void createList(Paths paths, GraphStore store, int[] parameters) {
	    int InstanceOf = store.identities.createPathToId(paths.InstanceOf);
		int Entry = store.identities.createPathToId(paths.List_Entry);
		int Next = store.identities.createPathToId(paths.List_Next);
		int Element = store.identities.createPathToId(paths.List_Element);

		int oldEntry = parameters[0];		
		for(int i=1;i<parameters.length;++i) {
		    int newEntry = store.identities.newResource();
		    store.statements.add(newEntry, InstanceOf, Entry);
		    store.statements.add(oldEntry, Next, newEntry);		    
		    store.statements.add(newEntry, Element, parameters[i]);
		    oldEntry = newEntry;
		}
		store.statements.add(oldEntry, Next, parameters[0]);
	}

}

