package org.simantics.graph.compiler.internal.store;

import org.simantics.graph.compiler.internal.ltk.Location;
import org.simantics.graph.store.IStore;
import org.simantics.graph.store.IndexMappingUtils;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;

public class LocationStore implements IStore {
	
	TIntObjectHashMap<Location> locations;

	public LocationStore(TIntObjectHashMap<Location> locations) {
		this.locations = locations;
	}

	public LocationStore() {
		this(new TIntObjectHashMap<Location>());
	}

	@Override
	public void map(TIntIntHashMap map) {
		locations = IndexMappingUtils.map(map, locations, new TIntHashSet());
	}
	
	public Location getLocation(int id) {
		return locations.get(id);
	}

	public void add(int resource, Location tree) {
		locations.putIfAbsent(resource, tree);		
	}

}
