package org.simantics.graph.compiler.internal.procedures;

import org.simantics.graph.query.Paths;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.IdentityStore;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;

public class MergeEqualResources implements Runnable {

	GraphStore store;
	Paths paths;
		
	public MergeEqualResources(Paths paths, GraphStore store) {
	    this.paths = paths;
		this.store = store;
	}

	@Override
	public void run() {
		IdentityStore identities = store.identities;
		if(identities.contains(paths.Equals)) {
			int equalsId = identities.pathToId(paths.Equals);
			identities.removeIdentity(equalsId);
			TIntArrayList rel = store.statements.extractRelation(equalsId);
			for(int i=0;i<rel.size();i+=2)
				identities.unify(rel.get(i), rel.get(i+1));
		}
		
		TIntIntHashMap map = identities.extractUnifications();
		do {
			store.map(map);			
			map = identities.extractUnifications();
		} while(!map.isEmpty());
	}	

}
