package org.simantics.graph.compiler.internal.parsing;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;

import org.simantics.databoard.util.StreamUtil;

public class SourceSplitter {
	
	public static class SplitPoint {
		public final int characterId;
		public final int lineId;
		
		public SplitPoint(int characterId, int lineId) {
			this.characterId = characterId;
			this.lineId = lineId;
		}
	}
	
	public static ArrayList<SplitPoint> split(String source, int minSplit) {
		int length = source.length();
		int inPar = 0;
		int lineId = 0;
		int lastSplit = 0;
		ArrayList<SplitPoint> result = new ArrayList<SplitPoint>();
		result.add(new SplitPoint(0, 0));
		loop: for(int i=0;i<length;++i) {
			char c = source.charAt(i);

			switch(c) {
			case '/':
				++i;
				c = source.charAt(i);
				if(c == '/') {
					do {
						++i;
						if(i == length)
							break loop;
					} while(source.charAt(i) != '\n');
					--i;
				}
				else if(c == '*') {
					++i;
					if(source.charAt(i) == '\n')
						++lineId;
					do {
						++i;
						if(i >= length)
							break loop;
						c = source.charAt(i);
						if(c == '\n')
							++lineId;
					} while(c != '/' || source.charAt(i-1) != '*');
				}
				break;
			case '<':
				++i;
				c = source.charAt(i);
				if(c != 'h') {
					if(c == '\n')
						++lineId;
					break;
				}
				do {
					++i;
					if(i == length)
						break loop;
					c = source.charAt(i);
					if(c == '\n') {
						++lineId;
						break;
					}
				} while(c != '>');
				break;
			case '"':
				++i;
				if(i == length)
					break loop;
				c = source.charAt(i);
				if(c == '"') {
					++i;
					if(i == length)
						break loop;
					c = source.charAt(i);
					if(c == '"') {
						while(true) {
							++i;
							if(i >= length)
								break;
							c = source.charAt(i);
							if(c == '\n')
								++lineId;
							else if(c == '"' && i < length-2 && source.charAt(i+1) == '"' && source.charAt(i+2) == '"') {
								i+=2;
								break;			
							}
						}
					}
					else
						--i;
				}
				else {
					while(true) {
						++i;
						if(i >= length)
							break;
						c = source.charAt(i);
						if(c == '"')
							break;
						else if(c == '\\')
							++i;			
						else if(c == '\n') {
							++lineId;
							break;
						}
					}
				}
				break;
			case '[':
			case '{':
			case '(':
				++inPar;
				break;
			case ']':
			case '}':
			case ')':
				--inPar;
				break;
			case '\n':
				++lineId;
				++i;
				if(i == length)
					break;
				c = source.charAt(i);
				if(c == '\r') {
					++i;
					if(i == length)
						break;
					c = source.charAt(i);
				}
				if(c == '\n') {
					--i;
					break;
				}
				/*System.out.println();
				System.out.print(lineId + "# ");
				System.out.print(c);
				*/
				if(i > lastSplit + minSplit && inPar == 0 && ((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z'))) {
					result.add(new SplitPoint(i, lineId));
					lastSplit = i;
				}
				else
					--i;
				break;
			case '\r':
				break;
			default:
				//System.out.print(c);
			}
		}
		result.add(new SplitPoint(length, lineId));
		return result;
	}
	
	public static void main(String[] args) throws Exception {		
		InputStream stream = SourceSplitter.class.getResourceAsStream("Layer0Deprecated.pgraph");
		String source = StreamUtil.readString(stream, Charset.forName("UTF-8"));
		stream.close();
		
		ArrayList<SplitPoint> sps = split(source, 1000); 
		for(int i=1;i<sps.size();++i) {
			SplitPoint begin = sps.get(i-1);
			SplitPoint end = sps.get(i);
			System.out.println("-- " + begin.lineId + ":" + end.lineId);
			System.out.print(source.subSequence(begin.characterId, end.characterId));
		}
	}
	
}
