package org.simantics.graph.compiler.internal.ltk;


public class Location {
	ISource source;
	int line;
	int beginPos;
	int endPos;
	
	public Location(ISource source, int line, int beginPos, int endPos) {
		this.source = source;
		this.line = line;
		this.beginPos = beginPos;
		this.endPos = endPos;
	}
	
	public Location(ISource source) {
		this(source, 0, 0, 0);
	}

	@Override
	public String toString() {
		return line + ":" + beginPos;
	}
	
	public ISource getSource() {
		return source;
	}
	
	public void setSource(ISource source) {
		this.source = source;
	}
	
	public int getLine() {
		return line + source.startLine();
	}
	
	public int getBeginPos() {
		return beginPos + source.startPos();
	}
	
	public int getEndPos() {
		return endPos + source.startPos();
	}
}
