package org.simantics.graph.compiler;

import java.util.Collection;

import org.simantics.graph.IResourceFile;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.representation.TransferableGraph1;

/**
 * Result of invoking GraphCompiler.compile.
 * @author Hannu Niemist�
 */
public class CompilationResult {
	TransferableGraph1 graph;
	Collection<Problem> errors;
	Collection<Problem> warnings;
	Collection<IResourceFile> resourceFiles;
	SourceInfo sourceInfo;
		
	public TransferableGraph1 getGraph() {
		return graph;
	}
	
	public Collection<Problem> getErrors() {
		return errors;
	}
	
	public Collection<Problem> getWarnings() {
		return warnings;
	}
	
	public Collection<IResourceFile> getResourceFiles() {
		return resourceFiles;
	}
	
	public SourceInfo getSourceInfo() {
		return sourceInfo;
	}
}
