/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.utils;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class ViewBoxUtils {
    private static final Rectangle2D defaultViewBox = new Rectangle2D.Double(-10.0, -10.0, 20.0, 20.0);

    public static Rectangle2D getDefaultViewBox() {
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrame(defaultViewBox);
        return r;
    }

    public static AffineTransform getViewTransform(Rectangle2D viewBox, Point2D canvasSize) {
        double sx = canvasSize.getX() / viewBox.getWidth();
        double sy = canvasSize.getY() / viewBox.getHeight();
        AffineTransform tr = new AffineTransform();
        tr.scale(sx, sy);
        tr.translate(-viewBox.getMinX(), -viewBox.getMinY());
        return tr;
    }

    public static AffineTransform getViewTransform(Rectangle2D viewBox, Point2D controlSize, Point2D usableControlSize) {
        double sx = usableControlSize.getX() / viewBox.getWidth();
        double sy = usableControlSize.getY() / viewBox.getHeight();
        AffineTransform tr = new AffineTransform();
        tr.translate((-usableControlSize.getX() + controlSize.getX()) / 2.0, (-usableControlSize.getX() + controlSize.getX()) / 2.0);
        tr.scale(sx, sy);
        tr.translate(-viewBox.getMinX(), -viewBox.getMinY());
        return tr;
    }

    public static Point2D interpolate(Rectangle2D r, double nx, double ny) {
        return new Point2D.Double(r.getMinX() + r.getWidth() * nx, r.getMinY() + r.getHeight() * ny);
    }

    public static Rectangle2D transformToViewBox(Point2D canvasSize, AffineTransform tr, boolean uniform) {
        double sx;
        double sy;
        if (uniform) {
            sx = sy = 1.0 / tr.getScaleX();
        } else {
            sx = 1.0 / tr.getScaleX();
            sy = 1.0 / tr.getScaleY();
        }
        double startX = -tr.getTranslateX() * sx;
        double startY = -tr.getTranslateY() * sy;
        double endX = startX + sx * canvasSize.getX();
        double endY = startY + sy * canvasSize.getY();
        return new Rectangle2D.Double(startX, startY, endX - startX, endY - startY);
    }

    public static void inflate(Rectangle2D r, double scale) {
        double cx = r.getCenterX();
        double cy = r.getCenterY();
        double nw = r.getWidth() * scale;
        double nh = r.getHeight() * scale;
        double nw2 = nw * 0.5;
        double nh2 = nh * 0.5;
        r.setFrame(cx - nw2, cy - nh2, nw, nh);
    }

    public static Rectangle2D inflated(Rectangle2D r, double scale) {
        Rectangle2D.Double r2 = new Rectangle2D.Double();
        r2.setFrame(r);
        ViewBoxUtils.inflate(r2, scale);
        return r2;
    }

    public static void uniformFitToCanvas(Point2D canvasSize, Rectangle2D viewBox) {
        double h;
        double sh;
        double cx = viewBox.getCenterX();
        double cy = viewBox.getCenterY();
        double cw = canvasSize.getX();
        double ch = canvasSize.getY();
        double w = viewBox.getWidth();
        double sw = cw / w;
        if (sw < (sh = ch / (h = viewBox.getHeight()))) {
            double dh = h * sw;
            double fh = h * ch / dh;
            viewBox.setFrameFromCenter(cx, cy, cx + w * 0.5, cy + fh * 0.5);
        } else if (sw > sh) {
            double dw = w * sh;
            double fw = w * cw / dw;
            viewBox.setFrameFromCenter(cx, cy, cx + fw * 0.5, cy + h * 0.5);
        }
    }

    public static void move(Rectangle2D r, double tx, double ty) {
        r.setFrame(r.getMinX() + tx, r.getMinY() + ty, r.getWidth(), r.getHeight());
    }

    public static Rectangle2D moved(Rectangle2D r, double tx, double ty) {
        Rectangle2D.Double r2 = new Rectangle2D.Double();
        r2.setFrame(r.getMinX() + tx, r.getMinY() + ty, r.getWidth(), r.getHeight());
        return r2;
    }

    public static Rectangle2D uniformZoomedViewBox(Rectangle2D viewBox, Point2D canvasSize, int px, int py, double sx, double sy) {
        return ViewBoxUtils.zoomedViewBox(viewBox, canvasSize, px, py, sx, sy, true);
    }

    public static Rectangle2D zoomedViewBox(Rectangle2D viewBox, Point2D canvasSize, int px, int py, double sx, double sy, boolean uniform) {
        if (sx <= 0.0 || sy <= 0.0) {
            throw new IllegalArgumentException("invalid scaling: " + sx + ", " + sy);
        }
        AffineTransform view = ViewBoxUtils.getViewTransform(viewBox, canvasSize);
        AffineTransform at = AffineTransform.getTranslateInstance(px, py);
        at.scale(sx, sy);
        at.translate(-px, -py);
        at.concatenate(view);
        Rectangle2D box = ViewBoxUtils.transformToViewBox(canvasSize, at, uniform);
        return box;
    }

    public static AffineTransform viewportToSquare(Rectangle2D viewport, Align horiz, Align vert) {
        boolean wide = viewport.getWidth() > viewport.getHeight();
        double shorterEdge = wide ? viewport.getHeight() : viewport.getWidth();
        double longerEdge = !wide ? viewport.getHeight() : viewport.getWidth();
        double tx = -viewport.getX();
        double ty = -viewport.getY();
        double s = 100.0 / shorterEdge;
        if (wide) {
            if (horiz == Align.Center) {
                tx += (longerEdge - shorterEdge) / 2.0;
            } else if (horiz == Align.End) {
                tx += longerEdge - shorterEdge;
            } else if (horiz == Align.Fill) {
                s = 100.0 / viewport.getWidth();
            }
        } else if (vert == Align.Center) {
            ty += (longerEdge - shorterEdge) / 2.0;
        } else if (vert == Align.End) {
            ty += longerEdge - shorterEdge;
        } else if (vert == Align.Fill) {
            s = 100.0 / viewport.getHeight();
        }
        AffineTransform at = new AffineTransform();
        at.scale(s, s);
        at.translate(tx, ty);
        return at;
    }

    public static AffineTransform squareToViewport(Rectangle2D viewport, Align horiz, Align vert) {
        AffineTransform at = ViewBoxUtils.viewportToSquare(viewport, horiz, vert);
        try {
            return at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Align {
        Begin,
        Center,
        End,
        Fill;

    }
}

